/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import jlibs.core.graph.Filter;
import jlibs.core.lang.Util;

public class ArrayUtil {
    public static <T, S extends T> int indexOf(T[] array, S item, int fromIndex) {
        if (array == null) {
            return -1;
        }
        for (int i = fromIndex; i < array.length; ++i) {
            if (!Util.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T, S extends T> int indexOf(T[] array, S item) {
        return ArrayUtil.indexOf(array, item, 0);
    }

    public static <T, S extends T> boolean contains(T[] array, S item) {
        return ArrayUtil.indexOf(array, item) != -1;
    }

    public static <T> T getFirst(T[] array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    public static <T> T getLast(T[] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    public static boolean equals(Object[] array1, int from1, Object[] array2, int from2, int length) {
        if (from1 < array1.length || from1 + length > array1.length) {
            return false;
        }
        if (from2 < array2.length || from2 + length > array2.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Util.equals(array1[from1 + i], array2[from2 + i])) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(Object[] array1, Object[] array2) {
        return ArrayUtil.equals(array1, 0, array2, 0, array2.length);
    }

    public static boolean endsWith(Object[] array1, Object[] array2) {
        return ArrayUtil.equals(array1, array1.length - array2.length, array2, 0, array2.length);
    }

    public static <T> T[] copy(Object[] src, T[] dest) {
        System.arraycopy(src, 0, dest, 0, Math.min(src.length, dest.length));
        return dest;
    }

    public static <T> T[] clone(Object[] src, Class<T> componentType) {
        return ArrayUtil.copy(src, (Object[])Array.newInstance(componentType, src.length));
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        ArrayList<T> filteredList = new ArrayList<T>(array.length);
        for (T element : array) {
            if (!filter.select(element)) continue;
            filteredList.add(element);
        }
        Object[] filteredArray = (Object[])Array.newInstance(array.getClass().getComponentType(), filteredList.size());
        return filteredList.toArray(filteredArray);
    }

    public static <T> T[] concat(Object[] array1, Object[] array2, Class<T> componentType) {
        Object[] newArray = (Object[])Array.newInstance(componentType, array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static Object[] concat(Object[] array1, Object[] array2) {
        Class<?> class2;
        Class<?> class1 = array1.getClass().getComponentType();
        Class<?> commonClass = class1.isAssignableFrom(class2 = array2.getClass().getComponentType()) ? class1 : (class2.isAssignableFrom(class1) ? class2 : Object.class);
        return ArrayUtil.concat(array1, array2, commonClass);
    }

    public static Boolean[] toObjectArray(boolean[] arr) {
        if (arr == null) {
            return null;
        }
        Boolean[] result = new Boolean[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Character[] toObjectArray(char[] arr) {
        if (arr == null) {
            return null;
        }
        Character[] result = new Character[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = Character.valueOf(arr[i]);
        }
        return result;
    }

    public static Byte[] toObjectArray(byte[] arr) {
        if (arr == null) {
            return null;
        }
        Byte[] result = new Byte[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Short[] toObjectArray(short[] arr) {
        if (arr == null) {
            return null;
        }
        Short[] result = new Short[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Integer[] toObjectArray(int[] arr) {
        if (arr == null) {
            return null;
        }
        Integer[] result = new Integer[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Long[] toObjectArray(long[] arr) {
        if (arr == null) {
            return null;
        }
        Long[] result = new Long[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static Float[] toObjectArray(float[] arr) {
        if (arr == null) {
            return null;
        }
        Float[] result = new Float[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = Float.valueOf(arr[i]);
        }
        return result;
    }

    public static Double[] toObjectArray(double[] arr) {
        if (arr == null) {
            return null;
        }
        Double[] result = new Double[arr.length];
        for (int i = arr.length - 1; i >= 0; --i) {
            result[i] = arr[i];
        }
        return result;
    }

    public static byte[] ensureCapacity(byte[] array, int capacity) {
        if (capacity <= 0 || capacity - array.length <= 0) {
            return array;
        }
        int newCapacity = array.length * 2;
        if (newCapacity - capacity < 0) {
            newCapacity = capacity;
        }
        if (newCapacity < 0) {
            if (capacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        return Arrays.copyOf(array, newCapacity);
    }

    public static char[] ensureCapacity(char[] array, int capacity) {
        if (capacity <= 0 || capacity - array.length <= 0) {
            return array;
        }
        int newCapacity = array.length * 2;
        if (newCapacity - capacity < 0) {
            newCapacity = capacity;
        }
        if (newCapacity < 0) {
            if (capacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        return Arrays.copyOf(array, newCapacity);
    }
}

